package gov.va.med.mhv.usermgmt.form;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionMapping;
import org.tigris.atlas.messages.MessageUtils;
import gov.va.med.mhv.core.web.util.XSSProcessor;


/**
 * The LoginForm class is responsible for handling user input.
 */
public class LoginForm extends LoginBaseForm {

	protected void doReset(ActionMapping mapping, HttpServletRequest request) {}

	protected void additionalValidation(HttpServletRequest request){
		cleanXSS();
		if (StringUtils.isBlank(getUserName()) || StringUtils.isBlank(getPassword()))
			getMessages().addMessage(MessageUtils.createErrorMessage("username.password.required",null,null));
	}

	private void cleanXSS() {
		setUserName( XSSProcessor.cleanXSS( getUserName() ) );
		setPassword( XSSProcessor.cleanXSS( getPassword() ) );
	}

}